/*  Sketch_for_testing_the_R4_DAC.ino
 *  A sketch for checking the capabilities of the DAC in the Arduino R4
 *  Minima.
 *  Written by Jim Rowe for Silicon Chip, on the 27th September 2023.
 *  Last revised at 8:50 am on 29/9/2023
 *  
 *  Note that the DAC's output appears at the A0 pin.
 *  Note that although the DAC is described as having a resolution of 12 bits,
 *  it has a default resolution of 8 bits. This can only be changed by using
 *  the instruction analogWriteResolution(12), but this is not accepted by
 *  earlier versions of the Arduino IDE.
 */

  int ReqAmp = 0;     // the requested amplitude (0 - 255)
  String InString = "";    // the serial input string
 //  analogWriteResolution(12);  // set the DAC resolution to 12 bits
  
void setup()
{
  Serial.begin(9600);   // then start up serial comms to PC at 9600 baud
  while(!Serial){}  // then wait until R4 serial port is awake
  Serial.println("This sketch is for checking the Arduino R4 Minima's DAC capability");
}

void loop()
{
  Serial.println("Please input the output amplitude you want (0 - 255)");
  InString = "";   // reset InString to null
  startSerial:
  if (Serial.available() > 0)   // if serial data is available
  {
    delay (100);  // wait until the full data arrives
    InString = Serial.readString();
    Serial.println("Received this input: " + InString); // and echo it back
    ReqAmp = InString.toInt(); // convert to an integer
    analogWrite(A0, ReqAmp);  // then send it to the DAC
    Serial.println("The amplitude sent to the DAC is " + String(ReqAmp));
    delay (20000);  // then pause for 20 secs to allow measurement 
  }
  else
  {
    goto startSerial;
  }
}
